clc
clear
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
% set(0,'defaultAxesFontSize',20);
% set(0,'defaultAxesFontName','TimesNewRoman');

%Input data
%Physical parameters
Rg=287.053; %Costante dell'aria (J/kg/K)
mu=1.81e-5; %viscosita` dinamica dell'aria a 20C (Pa s)
pa=101325;
Temp=293;                  %Temperature (K)
rho=pa/(Rg*Temp);
dt=1e-8;                %Time Step (s)
cG=60000/rho;
%Geometrical parameters
R1 =16e-3 ; % inner radius (m)
R2 =33e-3 ;  % outer radius (m)
Rm=(R1+R2)/2;
T1d=0; %deg
T2d=30; %deg
T_tiltd = 5; %deg
T1=T1d*pi/180;
T2=T2d*pi/180;
T_tilt = T_tiltd*pi/180;
Omega_rpm=[5 10:10:70]*1e3;
Omega=Omega_rpm*2*pi/60;
h_vec = (10:2:20)*1e-6;
h_min = h_vec(1);
no_pad=12;

sh=14e-6;
x_step = 13; % [deg] degrees before step starts

%Definizione numero elementini nelle due direzioni
M=30; %direzione radiale
N=30;%direzione circonferenziale
deltar=(R2-R1)/(M-1);
deltat=(T2-T1)/(N-1);
nR =linspace(R1,R2,M); %Vettore dei raggi
nT =linspace(T1,T2-deltat,N);%Vettore degli angoli
%caso di periodicit
% nT=[nT(end), nT, nT(1)];
[T,R] = meshgrid(nT,nR) ; %crea le coordinate di tutti i punti %nR lo replica su ogni riga %nT su ogni colonna
% Convert grid to cartesian coordintes
X = R.*cos(T);
Y = R.*sin(T);
%Definisco valore raggio
Rv=sqrt(X.^2+Y.^2);

H0 = ones(M,N)*h_min;
step_start = round(N*x_step/T2d);
H0(:,1:step_start) = h_min+sh;

figure
surf(X*1e3,Y*1e3,H0*1e6)
xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Air Gap Height ($\mu m$)')
pause(0.1)


%Variable Initialization
%COndizioni Periodicit
% pold=ones(N+2,M)*pa; %N+2 per periodicit circolare lungo theta
% pnew=ones(N+2,M)*pa;
%COndizioni di Dirichelet p=Pa sul bordo esterno

F_mat = zeros(length(h_vec),length(Omega));
W = zeros(size(Omega));
Qin = W;
Qout = W;
legend_cell = cell(1,length(h_vec));

for h_i = 1:length(h_vec)
    Pold=ones(M,N)*pa*1.01; %MODIFICATO
    Pnew=Pold;

    h_min = h_vec(h_i);
    fprintf('h = %d um\n',h_vec(h_i)*1e6)
    
    H0(:,:) = h_min;
    H0(:,1:step_start) = h_min+sh;

    for omega_ind=1:length(Omega)
    omega=Omega(omega_ind);


    tic
    err_P=10;
    err_F=10;
    err_G=10;

    %portate uscita nodo
    GN=zeros(M,N); %N and M are for BC
    GS=zeros(M,N);
    gO=zeros(M,N);
    gE=zeros(M,N);
    F0=0;
    F1=0;

    iter=0;
    contatore=0;
    toll=1e-5;
    while abs(err_P)>toll || abs(err_G)>toll || abs(err_F)>toll
        iter=iter+1;
        contatore=contatore+1;
        F0=F1;
        Pold=Pnew;


        ii=2:M-1;   jj=2:N-1; %Nodi interni
        %Calcolo portata uscita radiale
        GN(ii,jj)=-(Pold(ii-1,jj).*H0(ii-1,jj).^3.*Rv(ii-1,jj)+Pold(ii,jj).*H0(ii,jj).^3.*Rv(ii,jj))./(24*mu*Rg*Temp*deltar).*(Pold(ii,jj)-Pold(ii-1,jj));
        GS(ii,jj)=-(Pold(ii,jj).*H0(ii,jj).^3.*Rv(ii,jj)+Pold(ii+1,jj).*H0(ii+1,jj).^3.*Rv(ii+1,jj))./(24*mu*Rg*Temp*deltar).*(Pold(ii+1,jj)-Pold(ii,jj));
        %Calcolo portata uscita circonferenziale
        gOp(ii,jj)=-(Pold(ii,jj-1).*H0(ii,jj-1).^3+Pold(ii,jj).*H0(ii,jj).^3)./(12*mu*Rg*Temp*(Rv(ii,jj-1)+Rv(ii,jj)).*deltat).*(Pold(ii,jj)-Pold(ii,jj-1));
        gOc(ii,jj)=omega*(Pold(ii,jj-1).*H0(ii,jj-1).*Rv(ii,jj-1)+Pold(ii,jj).*H0(ii,jj).*Rv(ii,jj))./(4*Rg*Temp);
        gO(ii,jj)=gOp(ii,jj)+gOc(ii,jj);
        gEp(ii,jj)=-(Pold(ii,jj).*H0(ii,jj).^3+Pold(ii,jj+1).*H0(ii,jj+1).^3)./(12*mu*Rg*Temp*(Rv(ii,jj)+Rv(ii,jj+1)).*deltat).*(Pold(ii,jj+1)-Pold(ii,jj));
        gEc(ii,jj)=omega*(Pold(ii,jj).*H0(ii,jj).*Rv(ii,jj)+Pold(ii,jj+1).*H0(ii,jj+1).*Rv(ii,jj+1))./(4*Rg*Temp);
        gE(ii,jj)=gEp(ii,jj)+gEc(ii,jj);
        %Calcolo pressione meato da equazione di continuit
        Pnew(ii,jj)=Pold(ii,jj)+((GN(ii,jj)-GS(ii,jj))*deltat+(gO(ii,jj)-gE(ii,jj))*deltar).*(dt*Rg*Temp)./(H0(ii,jj).*Rv(ii,jj)*deltar*deltat);
        %Calcolo errore Pressione
        err_P=abs(max((Pnew(:)-Pold(:))./Pold(:)));
        % Err_P_i(iter)=err_P;

        %Diverge?
        if any(isnan(Pnew(:))) || any(isinf(Pnew(:)))
            fprintf('Iterations diverge\n');
            return;
        end
        %Calcolo della capacit di carico
        F1=sum((Pnew-pa)*deltar*deltat.*Rv,'all');

        %Calcolo della portata in uscita O-N-E-S
        Gin=sum(GN(ii,jj)*deltat+gO(ii,jj)*deltar,'all');
        Gout=sum(GS(ii,jj)*deltat+gE(ii,jj)*deltar,'all');
        % %Calcolo errore
        err_F=(F1-F0)/F1;
        err_G_num=sum(Gin-Gout,'all');
        err_G=err_G_num/Gout;

        %   if contatore==2000
        %      figure
        %    surf(X*1e3,Y*1e3,Pnew), hold on
        %    xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Pressure (Pa)')
        %    grid on,set(gca,'FontSize', 24)
        %    contatore=0;
        %   end

    end
    toc
    W(omega_ind)=F1*no_pad;
    Qin(omega_ind)=Gin*cG;
    Qout(omega_ind)=Gout*cG;

    figure
    surf(X*1e3,Y*1e3,Pnew)
    xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Pressure (Pa)')
    grid on
    pause(0.5)
    end
F_mat(h_i,:) = W;
end

%% Curve Caratteristiche
% Capacit di carico
figure 
hold on
for i = 1:length(h_vec)
plot(Omega_rpm*1e-3,F_mat(i,:))
legend_cell{i} = [num2str(h_vec(i)*1e6) ' $\mu m$ air gap'];
end
% plot(Omega_rpm*1e-3,ones(size(W))*Load,'k', 'DisplayName', 'Experimental')
% plot(Omega_rpm*1e-3,W,'ro') 
hold off
% plot(Omega_rpm(1:length(W))*1e-3,Load,'k')
legend(legend_cell,'Interpreter','latex','Location','northwest')
xlabel('Angular Speed $\omega$ (krpm)')
ylabel('Load Capacity $W$ (N)')
title('Spiral grooved bearing Theoretical load capacity')
% legend('Numerical','Experimental','Location','best')
% legend([h1,h2],'Location','best')
% legend show
axis padded
% figureEditor
grid on

%% Salvataggio
if sh==25e-6
F_mat_orig = F_mat;
h_vec_orig = h_vec;
save Step_static_orig F_mat_orig h_vec_orig Omega_rpm
else
F_mat_opt = F_mat;
h_vec_opt = h_vec;
save Step_static_opt F_mat_opt h_vec_opt Omega_rpm
end
